using System.Diagnostics.CodeAnalysis;
using Newtonsoft.Json;

namespace Tinycc.Resources;

[ExcludeFromCodeCoverage]
public class DomainsResponse
{
    public static readonly string DataItem = "domains";

    [JsonProperty("domains")]
    public IEnumerable<DomainItem> Domains { get; set; }

    public class DomainItem
    {
        [JsonProperty("custom_404_page")]
        public string Custom404Page { get; set; }

        [JsonProperty("custom_root_page")]
        public string CustomRootPage { get; set; }

        [JsonProperty("domain")]
        public string Domain { get; set; }

        [JsonProperty("hash_character_set")]
        public string HashCharacterSet { get; set; }

        [JsonProperty("hash_generation")]
        public string HashGeneration { get; set; }

        [JsonProperty("override_referer")]
        public bool? OverrideReferer { get; set; }

        [JsonProperty("redirect_code")]
        public int? RedirectCode { get; set; }

        [JsonProperty("robots_tag")]
        public string RobotsTag { get; set; }

        [JsonProperty("status")]
        public string Status { get; set; }

        [JsonProperty("use_https")]
        public bool? UseHttps { get; set; }
    }
}
