using System.Diagnostics.CodeAnalysis;
using Newtonsoft.Json;

namespace Tinycc.Resources;

[ExcludeFromCodeCoverage]
public class StatsResponse
{
    public static readonly string DataItem = "stats";

    [JsonProperty("stats")]
    public IEnumerable<StatsItem> Stats { get; set; }

    public class StatsItem
    {
        [JsonProperty("hash")]
        public string Hash { get; set; }

        [JsonProperty("total_clicks")]
        public int? TotalClicks { get; set; }

        [JsonProperty("unique_clicks")]
        public int? UniqueClicks { get; set; }
    }
}
