using System.Diagnostics.CodeAnalysis;
using Newtonsoft.Json;

namespace Tinycc.Resources;

[ExcludeFromCodeCoverage]
public class Url
{
    [JsonProperty("archived")]
    public bool? Archived { get; set; }

    [JsonProperty("created")]
    public DateTime? Created { get; set; }

    [JsonProperty("domain")]
    public string Domain { get; set; }

    [JsonProperty("email_stats")]
    public bool? EmailStats { get; set; }

    [JsonProperty("expiration_date")]
    public DateTime? ExpirationDate { get; set; }

    [JsonProperty("hash")]
    public string Hash { get; set; }

    [JsonProperty("last_visit")]
    public DateTime? LastVisit { get; set; }

    [JsonProperty("links")]
    public Link Links { get; set; }

    [JsonProperty("long_url")]
    public string LongUrl { get; set; }

    [JsonProperty("max_clicks")]
    public int? MaxClicks { get; set; }

    [JsonProperty("modified")]
    public DateTime? Modified { get; set; }

    [JsonProperty("note")]
    public string Note { get; set; }

    [JsonProperty("ping")]
    public bool? Ping { get; set; }

    [JsonProperty("protected")]
    public bool? Protected { get; set; }

    [JsonProperty("short_url")]
    public string ShortUrl { get; set; }

    [JsonProperty("short_url_with_protocol")]
    public string ShortUrlWithProtocol { get; set; }

    [JsonProperty("tags")]
    public IEnumerable<string> Tags { get; set; }

    [JsonProperty("total_clicks")]
    public int? TotalClicks { get; set; }

    [JsonProperty("unique_clicks")]
    public int? UniqueClicks { get; set; }

    public class Link
    {
        [JsonProperty("qr_small")]
        public string QrSmall { get; set; }

        [JsonProperty("qr_big")]
        public string QrBig { get; set; }

        [JsonProperty("qr_svg")]
        public string QrSvg { get; set; }

        [JsonProperty("stats")]
        public string Stats { get; set; }

        [JsonProperty("smart_link")]
        public string SmartLink { get; set; }
    }
}